from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import MySQLDatabaseIssueType

MESSAGES = {}

MESSAGES[MySQLDatabaseIssueType.FAILED_TO_FETCH_TABLES_FROM_SOURCE] = format_message("""
Failed to retrieve information about database tables on the source MySQL database server '{host}'.
Checking of tables of the database '{database}' on the target host will be skipped.
""")

MESSAGES[MySQLDatabaseIssueType.DIFFERENT_TABLES_SET] = format_message("""
MySQL database '{database}' on the source server and on the target server has a differing set of tables. The databases that are present on the source server, but are missing at the target server: {tables_list}
""")

MESSAGES[MySQLDatabaseIssueType.FAILED_TO_EXECUTE_SIMPLE_QUERY_AS_USER] = format_message("""
Failed to execute a simple SQL query 'SELECT 1' under user '{user}' for MySQL database '{database}'
""")

MESSAGES[MySQLDatabaseIssueType.CONNECTION_ERROR] = format_message("""
Failed to connect to the target MySQL database server '{host}' to check the database '{database}'
""")

MESSAGES[MySQLDatabaseIssueType.DATABASE_DOES_NOT_EXIST] = format_message("""
The database '{database}' is not present on the target database server '{host}'
""")

MESSAGES[MySQLDatabaseIssueType.MYSQL_CLIENT_GENERIC_ERROR] = format_message("""
A generic MySQL client error occurred while trying to check access to the database '{database}' on the host '{host}'. MySQL client output: {output}
""")

MESSAGES[MySQLDatabaseIssueType.INTERNAL_ERROR] = format_message("""
An internal error occurred: {reason}
Unable to check whether the MySQL database '{database}' was migrated correctly.
""")

MESSAGES[MySQLDatabaseIssueType.DATABASE_DOES_NOT_EXIST_IN_PANEL] = format_message("""
MySQL database '{database}' does not exist on the target panel.
All the other checks for that database will be skipped.
""")

MESSAGES[MySQLDatabaseIssueType.DATABASE_USER_DOES_NOT_EXIST_IN_PANEL] = format_message("""
Database user '{user}' does not exist for MySQL database '{database}' on target panel
""")

MESSAGES[MySQLDatabaseIssueType.ENCRYPTED_PASSWORD] = format_message("""
Cannot verify access to the database '{database}'. User '{user}' password is encrypted.
""")
