import os
import json


def get_json(data, encoder=None):
	return json.dumps(data, cls=encoder)


def read_json(filename):
	if not os.path.exists(filename):
		return None
	with open(filename, 'r') as dump_file:
		return json.load(dump_file)


def write_json(filename, data, encoder=None):
	with open(filename, 'w') as dump_file:
		json.dump(data, dump_file, cls=encoder)