# Copyright 1999-2015. Parallels IP Holdings GmbH. All Rights Reserved.
package Exception::XmlNode;


@Exception::XmlNode::ISA = qw(Error);


sub new
{
  my $self = shift;
  my $xmlNode = shift;

  my %params;
  $params{'message'} = \@_;
  $params{'xmlNode'} = $xmlNode;

  my @args = ();
  push (@args, '-value', \%params);

  local $Error::Depth = $Error::Depth + 1;
  local $Error::Debug = 1;  # enable stacktrace
  $self->SUPER::new(-text => "XmlNode exception: Invalid XmlNode", @args);
}

sub print {
  my $self = shift;
  my $params = $self->value();
  my $message = $params->{'message'};
  my $xmlNode = $params->{'xmlNode'};

  my $text = $self->text();
  $text .= "\n";
  if ( @$message ) {
    foreach my $msg ( @$message ) {
      $text .= "$msg: ";
    }
    $text .= "\n";
  }

  $text .= "-------- stacktrace start --------\n";
  $text .= $self->stacktrace();
  $text .= "--------  stacktrace end  --------\n";

  if ( defined ( $xmlNode ) ) {
    $text .= "------------ xml node ------------\n";
    $text .= $xmlNode->serialize();
  }
  else {
    $text .= "XmlNode source is not defined\n";
  }
  $text .= "----------------------------------\n";
  return $text;
}


1;
