from parallels.plesk import messages
import logging
import threading

from parallels.plesk.import_api.import_api_base import \
	PleskBaseImportAPI
from parallels.core.import_api.utils import plesk_unix_change_sysuser_login

logger = logging.getLogger(__name__)


class PleskUnixImportAPI(PleskBaseImportAPI):
	def __init__(self, conn):
		super(PleskUnixImportAPI, self).__init__(conn)
		self.lock = threading.Lock()

	def change_sysuser_login(self, subscription_name, sysuser_login):
		with self.conn.main_node_runner() as runner:
			# There is a problem in Plesk for Unix which could lead to
			# incorrect Apache configs if we run change system user login in
			# parallel. So we don't allow two threads to change system user
			# login at the same time.
			self.lock.acquire() 
			plesk_unix_change_sysuser_login(runner, subscription_name, sysuser_login)
			self.lock.release()

	@staticmethod
	def repair_webspace_security(subscription):
		raise NotImplementedError(messages.UNIX_IMPORT_API_REPAIR_WEBSPACE_NOT_APPLICABLE)

	def update_webspace_subdomains_security_metadata_location(self, subscription):
		"""
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		:rtype: None
		"""
		raise NotImplementedError(messages.UNIX_IMPORT_API_UPDATE_SECURITY_METADATA_LOCATION_NOT_APPLICABLE)

	@staticmethod
	def get_dedicated_app_pool_user(subscription):
		raise NotImplementedError(messages.UNIX_IMPORT_API_GET_DEDICATED_APP_POOL_USER_NOT_APPLICABLE)

	def refresh_node_components(self, node):
		raise NotImplementedError(messages.UNIX_IMPORT_API_REFRESH_NODE_COMPONENTS_NOT_APPLICABLE)
