from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import WebIssueSignatureType, WebsiteAvailabilityIssueType

MESSAGES = {}

MESSAGES[WebIssueSignatureType.SOURCE_PHP_FATAL_ERROR] = format_message(u"""
An error occurred, from which the script cannot be recovered, such as a
memory allocation problem. Execution of the script is halted.

Check the source server website for errors.
""")

MESSAGES[WebIssueSignatureType.SOURCE_PHP_WARNING] = format_message(u"""
There is a run-time warning (a non-fatal error). Execution of the script is not
halted.

Check the source server website for errors.
""")

MESSAGES[WebIssueSignatureType.SOURCE_PHP_NOTICE] = format_message(u"""
A run-time notice means that the script encountered something that
could indicate an error, but could also happen in the normal course of
the script running.

Check the source server website for errors.
""")

MESSAGES[WebIssueSignatureType.SOURCE_PHP_PARSE_ERROR] = format_message(u"""
An error occurred during the PHP script source file parsing. The PHP script was not executed.

Check the source server website for errors.
""")

MESSAGES[WebIssueSignatureType.SOURCE_PHP_STRICT_WARNING] = format_message(u"""
PHP suggested changes to the script code that would ensure the best
interoperability and forward compatibility of the code.

Check the source server website for errors.
""")

MESSAGES[WebIssueSignatureType.SOURCE_MYSQL_CANNOT_CONNECT_REMOTE] = format_message(u"""
The remote MySQL server is not available. 
The typical reasons are: 
- The server is stopped.
- The server hostname or IP is incorrect.
- The firewall blocks connections.
Usually that means that the site is completely inoperable.

Check the source server website for errors.
""")

MESSAGES[WebIssueSignatureType.SOURCE_MYSQL_CANNOT_CONNECT_LOCAL] = format_message(u"""
A web application cannot connect to the remote MySQL server.
The typical reasons are:
- The MySQL server is stopped.
- An incorrect Unix socket filename is specified in the PHP application. 
Usually that means that the site is completely inoperable.

Check the source server website for errors.
""")

MESSAGES[WebIssueSignatureType.SOURCE_MYSQL_UNKNOWN_DATABASE] = format_message(u"""
There is no such database on the database server. A possible reason is
that the database was not created or migrated, or it was removed.
Usually that means that the site is completely inoperable.

Check the source server website for errors.
""")

MESSAGES[WebIssueSignatureType.SOURCE_MYSQL_USER_ACCESS_DENIED] = format_message(u"""
Failed to log in to the database server. 
The typical reasons are:
- The credentials (login and password) are incorrect.
- The database does not allow remote access for the user.
Usually that means that the site is completely inoperable.

Check the source server website for errors.
""")

MESSAGES[WebIssueSignatureType.ONLY_TARGET_PHP_FATAL_ERROR] = format_message(u"""
A critical error occurred during a PHP script execution and stopped
the script execution. For example, the script could run out of
memory.

Check that the site was not broken during the migration and 
is working fine on the target server.
""")

MESSAGES[WebIssueSignatureType.ONLY_TARGET_PHP_WARNING] = format_message(u"""
A non-critical warning occurred during a PHP script execution. The script 
continues working, but the result might be incorrect.

Check that the site was not broken during the migration and 
is working fine on the target server.
""")

MESSAGES[WebIssueSignatureType.ONLY_TARGET_PHP_NOTICE] = format_message(u"""
A run-time notice means that the script encountered something that
could indicate an error, but could also happen in the normal course of
the script running.

Check that the site was not broken during the migration and 
is working fine on the target server.
""")

MESSAGES[WebIssueSignatureType.ONLY_TARGET_PHP_PARSE_ERROR] = format_message(u"""
An error occurred during the PHP script source file parsing. The script
was not executed. Usually that means that the site is completely
inoperable.

Check that the site was not broken during the migration and 
is working fine on the target server.
""")

MESSAGES[WebIssueSignatureType.ONLY_TARGET_PHP_STRICT_WARNING] = format_message(u"""
There is a warning that proposes to change the code for better
compatibility with the next versions of PHP. Usually you could ignore
it, but in some cases the result might be incorrect.

Check that the site was not broken during the migration and 
is working fine on the target server.
""")

MESSAGES[WebIssueSignatureType.ONLY_TARGET_MYSQL_CANNOT_CONNECT_REMOTE] = format_message(u"""
The remote MySQL server is not available.
The typical reasons are: 
- The server is stopped.
- The server hostname or IP is incorrect.
- The firewall blocks connections.
Usually that means that the site is completely inoperable.

Check that the site was not broken during the migration and 
is working fine on the target server.
""")

MESSAGES[WebIssueSignatureType.ONLY_TARGET_MYSQL_CANNOT_CONNECT_LOCAL] = format_message(u"""
A web application cannot connect to the remote MySQL server.
Usually that means that the site is completely inoperable.
The typical reasons are:
- The MySQL server is stopped.
- An incorrect Unix socket filename is specified in the PHP application.
Usually that means that the site is completely inoperable.

Check that the site was not broken during the migration and 
is working fine on the target server.
""")

MESSAGES[WebIssueSignatureType.ONLY_TARGET_MYSQL_UNKNOWN_DATABASE] = format_message(u"""
There is no such database on the database server
A possible reason is the database was not created or migrated, or it was removed.
Usually that means that the site is completely inoperable.

Check that the site was not broken during the migration and 
is working fine on the target server.
""")

MESSAGES[WebIssueSignatureType.ONLY_TARGET_MYSQL_USER_ACCESS_DENIED] = format_message(u"""
Failed to log in to the database server
The typical reasons are:
- The credentials (login and password) are incorrect.
- The database does not allow remote access for the user.
Usually that means that the site is completely inoperable.

Check that the site was not broken during the migration and 
is working fine on the target server.
""")

MESSAGES[WebsiteAvailabilityIssueType.DIFFERENT_TITLES] = format_message(u"""
A changed page title might signify the target web server misconfiguration.

Open the migrated site in a web browser and check it for errors.
""")

MESSAGES[WebsiteAvailabilityIssueType.DIFFERENT_STATUS_CODE] = format_message(u"""
A changed HTTP status code might signify either the source or the
target web server misconfiguration.

Open the website on the source and target web servers and visually compare
the web pages.
""")

MESSAGES[WebsiteAvailabilityIssueType.CONNECTION_ISSUE] = format_message(u"""
There is a problem with the network connectivity or the web server startup.

Make sure the web server is started and connections are not blocked by
the firewall.
""")

MESSAGES[WebsiteAvailabilityIssueType.UNABLE_TO_GET_SOURCE_SITE] = format_message(u"""
There is a problem with the network connectivity or the web server startup.

Make sure the web server is started and connections are not blocked by
the firewall.
""")

MESSAGES[WebsiteAvailabilityIssueType.INTERNAL_ERROR] = format_message(u"""
The website cannot be checked because of a run-time error that occurred
in the hosting checker. 

Contact Parallels support.
""")

MESSAGES[WebsiteAvailabilityIssueType.STATUS_CODE_5xx] = format_message(u"""
The web server is unable to process a request.

Verify the web server and website log files.
""")

MESSAGES[WebsiteAvailabilityIssueType.STATUS_CODE_4xx] = format_message(u"""
The web server designates that there is an error in a client request.

Check the HTTP status code number.
""")
