from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import MySQLDatabaseIssueType

MESSAGES = {}

MESSAGES[MySQLDatabaseIssueType.DIFFERENT_TABLES_SET] = format_message("""
Make sure that the database content was migrated successfully.
If it was not, run the "{util_name} copy-db-content" command
to retry migrating the database content, or copy the database content manually.
""")

MESSAGES[MySQLDatabaseIssueType.FAILED_TO_EXECUTE_SIMPLE_QUERY_AS_USER] = format_message("""
Ensure that the database user is present both in the hosting panel and on the target database server.
Another possible reason is that password was changed for that user on the target panel after migration.
""")

MESSAGES[MySQLDatabaseIssueType.CONNECTION_ERROR] = format_message("""
Please make sure that:
1. The target MySQL database server is started and running.
2. There are no firewall rules that may block connection to the server.
""")

MESSAGES[MySQLDatabaseIssueType.DATABASE_DOES_NOT_EXIST_IN_PANEL] = format_message("""
To transfer the database from the source server, you need to either restart the migration 
of the entire subscription by means of the '{util_name} transfer-accounts' command, 
or create the database manually from the hosting panel and then run the '{util_name} copy-db-content' command.
""")

MESSAGES[MySQLDatabaseIssueType.DATABASE_USER_DOES_NOT_EXIST_IN_PANEL] = format_message("""
Most likely some web application, which uses the database, does not work after migration.
To transfer the database user from the source server, you need to try to restart the migration 
of the entire subscription by means of the '{util_name} transfer-accounts' command. 
Another way is to recreate the user manually.
""")

MESSAGES[MySQLDatabaseIssueType.DATABASE_DOES_NOT_EXIST] = format_message("""
To transfer the database from the source server, you need to either restart the migration 
of the entire subscription by means of the '{util_name} transfer-accounts' command, 
or create the database manually from the hosting panel and then run the '{util_name} copy-db-content' command.
""")

MESSAGES[MySQLDatabaseIssueType.MYSQL_CLIENT_GENERIC_ERROR] = format_message("""
Refer to the official MySQL documentation to learn more about this issue and about how to resolve it.
""")

MESSAGES[MySQLDatabaseIssueType.INTERNAL_ERROR] = format_message("""
Manually check whether this database and database users were migrated properly.
""")
