from parallels.core import messages
import logging

from parallels.core.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.core.actions.utils.logging_properties \
	import LoggingProperties

logger = logging.getLogger(__name__)


class ChangeWebmailToHorde(SubscriptionBackupAction):
	"""Recent Plesk versions (since 11.5) do not support atmail as webmail, so we change it in
	backup to prevent warning on hosting restore step also we change any not
	supported webmail to horde in order to prevent warnings on restore"""

	def get_description(self):
		return messages.CHANGE_WEBMAIL_FROM_OLD_WEBMAILS_HORDE

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		return messages.FAILED_CHANGE_WEBMAIL_FOR_SUBSCRIPTION_S % (subscription.name)

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return False

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		s_mailsystem = subscription_backup.mailsystem

		if s_mailsystem is not None:
			if s_mailsystem.get_webmail() not in ['horde', 'roundcube']:
				s_mailsystem.set_webmail('horde')
				logger.debug(messages.SUBSCRIPTION_S_WEBMAIL_THAT_DOES_NOT % subscription.name)
