<?xml version="1.0" encoding="utf-8"?>
<!-- Copyright 1999-2026. WebPros International GmbH. All rights reserved. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="text" indent="yes"/>
    <xsl:variable name="newline">
        <xsl:text>&lt;br/&gt;</xsl:text>
    </xsl:variable>
    <xsl:variable name="tab">
        <xsl:text>      </xsl:text>
    </xsl:variable>
    <xsl:template match="message">
        <xsl:param name="class"/>
        &lt;div class="<xsl:value-of select="$class"/>"&gt;
        <xsl:choose>
            <xsl:when test="@severity='error'">&lt;b&gt;Error:&lt;/b&gt;</xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="@severity='warning'">&lt;b&gt;Warning:&lt;/b&gt;</xsl:when>
                    <xsl:otherwise>&lt;b&gt;Info:&lt;/b&gt;</xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose><xsl:value-of select="$tab"/><xsl:if test="local-name(..)='object'">
        &lt;b&gt;<xsl:value-of select="../@type"/>&lt;/b&gt; "<xsl:value-of select="../@name"/>"</xsl:if><xsl:value-of select="$newline"/>
        &lt;code style=&quot;white-space:pre-wrap&quot;&gt;<xsl:choose>
            <xsl:when test="description[@encoding = 'base64']">@BASE_64_BEGIN@<xsl:value-of select="description"/>@BASE_64_END@</xsl:when>
            <xsl:otherwise>@ESCAPE_VALUE_BEGIN@<xsl:value-of select="description"/>@ESCAPE_VALUE_END@</xsl:otherwise>
        </xsl:choose>&lt;/code&gt;
        <xsl:apply-templates select="message">
            <xsl:with-param name="class" select="'indent-box'"/>
        </xsl:apply-templates>
        &lt;/div&gt;
    </xsl:template>
</xsl:stylesheet>