CREATE TABLE `aps_registry_object` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`uid` varchar(36) NOT NULL,
	`type` varchar(256) NOT NULL,
	`creation_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`enabled` char(1) CHARACTER SET latin1 NOT NULL DEFAULT 'y',
	PRIMARY KEY (`id`),
	UNIQUE KEY `IX_aps_registry_object_uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_settings_sequenses` (
	`sequence_id` varchar(255) NOT NULL,
	`counter` int(10) unsigned NOT NULL,
	PRIMARY KEY (`sequence_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_package_series` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`aps_package_id` varchar(255) NOT NULL,
	`aps10_name` varchar(255) NOT NULL,
	`commercial_name` varchar(255) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `IX_aps_package_series_aps_package_id` (`aps_package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_package` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`registry_object_id` int(10) unsigned NOT NULL,
	`series_id` int(10) unsigned NOT NULL,
	`master_series_id` int(10) unsigned DEFAULT NULL,
	`name` varchar(255) NOT NULL,
	`version` varchar(16) NOT NULL,
	`archive_uri` varchar(255) NOT NULL,
	`metafile_uri` varchar(255) NOT NULL,
	`source_uri` varchar(255) DEFAULT NULL,
	`is_addon` char(1) NOT NULL DEFAULT 'n',
	`master_match` varchar(255) NOT NULL DEFAULT '',
	`master_package_id` varchar(255) NOT NULL DEFAULT '',
	`release` varchar(16) NOT NULL,
	`content_root_uri` varchar(255) NOT NULL,
	`spec_version` varchar(16) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `IX_aps_package_series_version` (`series_id`,`version`,`release`),
	KEY `FK_aps_package_aps_registry_object` (`registry_object_id`),
	CONSTRAINT `FK_aps_package_aps_package_series` FOREIGN KEY (`series_id`) REFERENCES `aps_package_series` (`id`),
	CONSTRAINT `FK_aps_package_aps_registry_object` FOREIGN KEY (`registry_object_id`) REFERENCES `aps_registry_object` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_application_backup` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`registry_object_id` int(10) unsigned NOT NULL,
	`app_uid` char(36) CHARACTER SET latin1 NOT NULL,
	`package_id` int(10) unsigned NOT NULL,
	`ext_backup_id` varchar(255) DEFAULT NULL,
	PRIMARY KEY (`id`),
	KEY `FK_aps_application_backup_aps_package` (`package_id`),
	KEY `FK_aps_application_backup_aps_registry_object` (`registry_object_id`),
	CONSTRAINT `FK_aps_application_backup_aps_package` FOREIGN KEY (`package_id`) REFERENCES `aps_package` (`id`) ON DELETE CASCADE,
	CONSTRAINT `FK_aps_application_backup_aps_registry_object` FOREIGN KEY (`registry_object_id`) REFERENCES `aps_registry_object` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_resource_backup` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`registry_object_id` int(10) unsigned NOT NULL,
	`app_backup_id` int(10) unsigned DEFAULT NULL,
	`resource_uid` char(36) NOT NULL,
	`ext_backup_id` varchar(255) DEFAULT NULL,
	`parent_resource_backup_id` int(10) unsigned DEFAULT NULL,
	`parent_resource_uid` char(36) DEFAULT NULL,
	`service_id` varchar(64) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `IX_aps_resource_backup_application_backup` (`app_backup_id`,`resource_uid`),
	KEY `FK_aps_resource_backup_aps_registry_object` (`registry_object_id`),
	KEY `FK_aps_resource_backup_aps_resource_backup` (`parent_resource_backup_id`),
	CONSTRAINT `FK_aps_resource_backup_aps_application_backup` FOREIGN KEY (`app_backup_id`) REFERENCES `aps_application_backup` (`id`) ON DELETE CASCADE,
	CONSTRAINT `FK_aps_resource_backup_aps_registry_object` FOREIGN KEY (`registry_object_id`) REFERENCES `aps_registry_object` (`id`),
	CONSTRAINT `FK_aps_resource_backup_aps_resource_backup` FOREIGN KEY (`parent_resource_backup_id`) REFERENCES `aps_resource_backup` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_registry_object_setting` (
	`name` varchar(64) NOT NULL,
	`value` text NOT NULL,
	`order_num` int(10) unsigned NOT NULL,
	`uuid` varchar(255) DEFAULT NULL,
	`registry_object_id` int(10) unsigned NOT NULL,
	UNIQUE KEY `IX_aps_registry_object_setting` (`name`,`order_num`,`registry_object_id`) USING BTREE,
	KEY `FK_aps_registry_object_setting_aps_registry_object` (`registry_object_id`),
	CONSTRAINT `FK_aps_registry_object_setting_aps_registry_object` FOREIGN KEY (`registry_object_id`) REFERENCES `aps_registry_object` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_registry_object_tag` (
	`registry_object_id` int(10) unsigned NOT NULL,
	`name` varchar(64) NOT NULL,
	`value` varchar(255) NOT NULL DEFAULT '',
	KEY `FK_aps_registry_object_tag_aps_registry_object` (`registry_object_id`),
	CONSTRAINT `FK_aps_registry_object_tag_aps_registry_object` FOREIGN KEY (`registry_object_id`) REFERENCES `aps_registry_object` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_package_configuration` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`uid` varchar(36) NOT NULL,
	`series_id` int(10) unsigned NOT NULL,
	`is_primary` char(1) CHARACTER SET latin1 NOT NULL DEFAULT 'n',
	PRIMARY KEY (`id`,`series_id`),
	UNIQUE KEY `IX_aps_package_configuration_uid` (`uid`),
	KEY `FK_aps_package_configuration_aps_package_series` (`series_id`),
	CONSTRAINT `FK_aps_package_configuration_aps_package_series` FOREIGN KEY (`series_id`) REFERENCES `aps_package_series` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_application` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`registry_object_id` int(10) unsigned NOT NULL,
	`master_app_id` int(10) unsigned DEFAULT NULL,
	`package_config_id` int(10) unsigned NOT NULL,
	`package_id` int(10) unsigned NOT NULL,
	`name` varchar(255) DEFAULT NULL,
	PRIMARY KEY (`id`),
	KEY `FK_aps_application_aps_package` (`package_id`),
	KEY `FK_aps_application_aps_package_configuration` (`package_config_id`),
	KEY `FK_aps_application_aps_registry_object` (`registry_object_id`),
	CONSTRAINT `FK_aps_application_aps_package` FOREIGN KEY (`package_id`) REFERENCES `aps_package` (`id`),
	CONSTRAINT `FK_aps_application_aps_package_configuration` FOREIGN KEY (`package_config_id`) REFERENCES `aps_package_configuration` (`id`),
	CONSTRAINT `FK_aps_application_aps_registry_object` FOREIGN KEY (`registry_object_id`) REFERENCES `aps_registry_object` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_resource` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`registry_object_id` int(10) unsigned NOT NULL,
	`parent_resource_id` int(10) unsigned DEFAULT NULL,
	`service_id` varchar(64) NOT NULL,
	`resource_type` varchar(256) NOT NULL,
	`app_id` int(10) unsigned DEFAULT NULL,
	PRIMARY KEY (`id`),
	KEY `FK_aps_resource_aps_registry_object` (`registry_object_id`),
	KEY `FK_aps_resource_aps_application` (`app_id`),
	CONSTRAINT `FK_aps_resource_aps_application` FOREIGN KEY (`app_id`) REFERENCES `aps_application` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
	CONSTRAINT `FK_aps_resource_aps_registry_object` FOREIGN KEY (`registry_object_id`) REFERENCES `aps_registry_object` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_resource_requirement_backup` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`resource_backup_id` int(10) unsigned NOT NULL,
	`uid` char(36) NOT NULL,
	`type` varchar(255) NOT NULL,
	`requirement_id` varchar(255) NOT NULL,
	`ext_backup_id` varchar(255) DEFAULT NULL,
	`branch` varchar(255) DEFAULT NULL,
	PRIMARY KEY (`id`),
	KEY `FK_aps_resource_requirement_backup_aps_resource_backup` (`resource_backup_id`),
	CONSTRAINT `FK_aps_resource_requirement_backup_aps_resource_backup` FOREIGN KEY (`resource_backup_id`) REFERENCES `aps_resource_backup` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_package_service` (
	`package_id` int(10) unsigned NOT NULL,
	`service_id` varchar(64) NOT NULL,
	`resource_type` varchar(256) NOT NULL,
	`service_class` varchar(64) NOT NULL,
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	PRIMARY KEY (`id`),
	KEY `FK_aps_package_service_aps_package` (`package_id`),
	CONSTRAINT `FK_aps_package_service_aps_package` FOREIGN KEY (`package_id`) REFERENCES `aps_package` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_package_global_setting` (
	`name` varchar(64) NOT NULL,
	`value` text NOT NULL,
	`order_num` int(10) unsigned NOT NULL,
	`package_config_id` int(10) unsigned NOT NULL,
	KEY `FK_aps_package_global_setting_aps_package_configuration` (`package_config_id`),
	KEY `IX_aps_package_global_setting` (`name`,`order_num`,`package_config_id`) USING BTREE,
	CONSTRAINT `FK_aps_package_global_setting_aps_package_configuration` FOREIGN KEY (`package_config_id`) REFERENCES `aps_package_configuration` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_package_resource_configuration` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`package_config_id` int(10) unsigned NOT NULL,
	`service_id` varchar(64) NOT NULL,
	`resource_type` varchar(256) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `IX_aps_package_resource_configuration` (`package_config_id`,`service_id`) USING BTREE,
	CONSTRAINT `FK_aps_package_resource_configuration_aps_package_configuration` FOREIGN KEY (`package_config_id`) REFERENCES `aps_package_configuration` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_package_resource_setting` (
	`name` varchar(64) NOT NULL,
	`value` text NOT NULL,
	`order_num` int(10) unsigned NOT NULL,
	`resource_config_id` int(10) unsigned NOT NULL,
	UNIQUE KEY `IX_aps_package_resource_setting` (`name`,`order_num`,`resource_config_id`) USING BTREE,
	KEY `FK_aps_package_resource_setting_aps_package_resource_configurat` (`resource_config_id`),
	CONSTRAINT `FK_aps_package_resource_setting_aps_package_resource_configurat` FOREIGN KEY (`resource_config_id`) REFERENCES `aps_package_resource_configuration` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_resource_usage_report` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`resource_id` int(10) unsigned NOT NULL,
	`last_update_timestamp` bigint(20) unsigned NOT NULL,
	`poll_interval` int(10) unsigned NOT NULL DEFAULT '0',
	PRIMARY KEY (`id`),
	UNIQUE KEY `IX_aps_resource_usage_report_resource` (`resource_id`),
	CONSTRAINT `FK_aps_resource_usage_report_aps_resource` FOREIGN KEY (`resource_id`) REFERENCES `aps_resource` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_resource_usage_counter` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`report_id` int(10) unsigned NOT NULL,
	`counter_id` varchar(64) NOT NULL,
	`unit` varchar(32) NOT NULL,
	`value` int(10) unsigned NOT NULL DEFAULT '0',
	`limit_value` bigint(20) unsigned NOT NULL DEFAULT '0',
	PRIMARY KEY (`id`),
	UNIQUE KEY `IX_aps_resource_usage_counter_report` (`report_id`,`counter_id`),
	CONSTRAINT `FK_aps_resource_usage_counter_aps_resource_usage_report` FOREIGN KEY (`report_id`) REFERENCES `aps_resource_usage_report` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_resource_requirement` (
	`uid` varchar(36) NOT NULL,
	`type` varchar(255) NOT NULL,
	`resource_id` int(10) unsigned NOT NULL,
	`requirement_id` varchar(255) NOT NULL,
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`branch` varchar(255) DEFAULT NULL,
	PRIMARY KEY (`id`) USING BTREE,
	KEY `FK_aps_resource_requirement_aps_resource` (`resource_id`),
	CONSTRAINT `FK_aps_resource_requirement_aps_resource` FOREIGN KEY (`resource_id`) REFERENCES `aps_resource` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_resource_adjacency_list` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`base_resource_id` int(10) unsigned NOT NULL,
	`dependent_resource_id` int(10) unsigned NOT NULL,
	`relation` char(1) NOT NULL DEFAULT 'e',
	`uniqueness_scope` varchar(255) DEFAULT NULL,
	`branch` varchar(255) DEFAULT NULL,
	`requirement_id` varchar(255) NOT NULL DEFAULT '',
	PRIMARY KEY (`id`),
	UNIQUE KEY `IX_aps_resource_adjacency_list_unique_link` (`base_resource_id`,`dependent_resource_id`),
	KEY `FK_aps_resource_adjacency_list_base` (`base_resource_id`),
	KEY `FK_aps_resource_adjacency_list_dependent` (`dependent_resource_id`),
	CONSTRAINT `FK_aps_resource_adjacency_list_base` FOREIGN KEY (`base_resource_id`) REFERENCES `aps_resource` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
	CONSTRAINT `FK_aps_resource_adjacency_list_dependent` FOREIGN KEY (`dependent_resource_id`) REFERENCES `aps_resource` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_resource_log` (
	`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	`resource_id` int(10) unsigned NOT NULL,
	`uid` varchar(36) NOT NULL,
	`severity` int(10) unsigned NOT NULL,
	`content` varchar(4000) NOT NULL,
	`log_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	CONSTRAINT `FK_aps_resource_log_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `aps_resource` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `aps_log_param` (
	`resource_log_id` int(10) unsigned NOT NULL,
	`name` varchar(64) NOT NULL,
	`value` varchar(4000) NOT NULL,
	PRIMARY KEY (`resource_log_id`, `name`),
	CONSTRAINT `FK_aps_log_param_resource_log_id` FOREIGN KEY (`resource_log_id`) REFERENCES `aps_resource_log` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

